/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.config.Config;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class MobDropsLootModifier
extends LootModifier {
    private final EntityType<?> entity;
    private final List<Item> weapons;
    private final Item bonusDropItem;
    private final float bonusDropChance;
    private final int minDropAmount;
    private final int maxDropAmount;

    public MobDropsLootModifier(LootItemCondition[] conditionsIn, EntityType<?> entity, List<Item> weapons, Item bonusDropItem, float bonusDropChance, int minDropAmount, int maxDropAmount) {
        super(conditionsIn);
        this.entity = entity;
        this.weapons = weapons;
        this.bonusDropItem = bonusDropItem;
        this.bonusDropChance = bonusDropChance;
        this.minDropAmount = minDropAmount;
        this.maxDropAmount = maxDropAmount;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity killer = (Entity)context.m_78953_(LootContextParams.f_81458_);
        Entity victim = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (killer instanceof Player) {
            Player player = (Player)killer;
            if (this.entity != null && ((Boolean)Config.AdditionalDropsConfig.enableAdditionalMobDrops.get()).booleanValue() && victim != null && this.entity.equals((Object)victim.m_6095_())) {
                ItemStack useItem = player.m_21205_();
                for (Item weapon : this.weapons) {
                    if (!useItem.m_150930_(weapon) || !((double)this.bonusDropChance > 0.0) || this.bonusDropItem == null) continue;
                    Random random = context.m_78933_();
                    if (this.maxDropAmount < this.minDropAmount || !(random.nextFloat() <= this.bonusDropChance)) continue;
                    generatedLoot.add(new ItemStack((ItemLike)this.bonusDropItem, random.ints(this.minDropAmount, this.maxDropAmount + 1).iterator().nextInt()));
                }
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<MobDropsLootModifier> {
        public MobDropsLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"entity")));
            ArrayList<Item> weapons = new ArrayList<Item>();
            JsonObject bonusDropObject = GsonHelper.m_13930_((JsonObject)object, (String)"bonus_drop");
            JsonArray weaponArray = GsonHelper.m_13933_((JsonObject)bonusDropObject, (String)"weapons");
            for (JsonElement weapon : weaponArray) {
                weapons.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weapon.getAsString())));
            }
            Item bonusDropItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)bonusDropObject, (String)"item")));
            float bonusDropChance = GsonHelper.m_13915_((JsonObject)bonusDropObject, (String)"chance");
            int minDropAmount = GsonHelper.m_13927_((JsonObject)bonusDropObject, (String)"min");
            int maxDropAmount = GsonHelper.m_13927_((JsonObject)bonusDropObject, (String)"max");
            return new MobDropsLootModifier(ailootcondition, entity, weapons, bonusDropItem, bonusDropChance, minDropAmount, maxDropAmount);
        }

        public JsonObject write(MobDropsLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            JsonObject bonusDropObject = new JsonObject();
            object.addProperty("entity", ForgeRegistries.ENTITIES.getKey(instance.entity).toString());
            JsonArray weaponArray = new JsonArray();
            for (Item weapon : instance.weapons) {
                weaponArray.add(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)weapon).toString());
            }
            object.add("bonus_drop", (JsonElement)bonusDropObject);
            bonusDropObject.add("weapons", (JsonElement)weaponArray);
            bonusDropObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.bonusDropItem).toString());
            bonusDropObject.addProperty("chance", (Number)Float.valueOf(instance.bonusDropChance));
            bonusDropObject.addProperty("min", (Number)instance.minDropAmount);
            bonusDropObject.addProperty("max", (Number)instance.maxDropAmount);
            return object;
        }
    }
}

